import numpy as np
# If I tell you the first dice is 1
# H(X) = 2.584962500721156

# If I tell you the sum is <= 7
# H(X) = 2.3983029951155594

def main():
    pmf = {
        1:1,
        2:0.2,
        3:0.2,
        4:0.1
    }

    # pmf = sum_two_dice_pmf()

    # print("I tell you the sum is even...")
    # for i in range(2, 13):
    #     if i % 2 != 0:
    #         pmf[i] = 0

    # print("I tell you the sum is odd...")
    # for i in range(2, 13):
    #     if i % 2 != 1:
    #         pmf[i] = 0

    # print("I tell you the first dice is 1...")
    # for i in range(8, 13):
    #     pmf[i] = 0
    # for i in range(2, 8):
    #     pmf[i] = 1/6


    normalize_pmf(pmf)
    print_pmf(pmf)
    

    uncertainty = calc_uncertainty(pmf)
    print(f"Entropy H(X) = {uncertainty}")

def calc_uncertainty(pmf):
    # this calculates the entropy of the distribution
    # aka the uncertainty
    uncertainty = 0
    for x_i in pmf:
        p_i = pmf[x_i]
        if p_i == 0:
            continue
        suprise_i = np.log2(1/p_i)
        uncertainty += suprise_i * p_i
    return uncertainty

def print_pmf(pmf):
    print("Probability Mass Function (PMF):")
    print("x    p(X = x)")
    print('-------------')
    for x_i in pmf:
        pr = pmf[x_i]
        if pr > 0:
            print(f"{x_i}      {pmf[x_i]:.3f}")
    print('-------------')

def normalize_pmf(pmf):
    total = sum(pmf.values())
    for x in pmf:
        pmf[x] /= total


def sum_two_dice_pmf():
    pmf = {}
    for i in range(1, 7):
        for j in range(1, 7):
            if i + j in pmf:
                pmf[i + j] += 1
            else:
                pmf[i + j] = 1
    return pmf

if __name__ == '__main__':
    main()